"use client"

import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs"
import { CustomerSignupForm } from "./customer-signup-form"
import { AgentSignupForm } from "./agent-signup-form"
import { User, Briefcase } from "lucide-react"

export function CreateAccountTabs() {
  return (
    <Tabs defaultValue="customer" className="w-full">
      <TabsList className="grid w-full grid-cols-2 mb-6">
        <TabsTrigger value="customer" className="gap-2">
          <User className="h-4 w-4" aria-hidden="true" />
          <span>Customer</span>
        </TabsTrigger>
        <TabsTrigger value="agent" className="gap-2">
          <Briefcase className="h-4 w-4" aria-hidden="true" />
          <span>Agent</span>
        </TabsTrigger>
      </TabsList>
      <TabsContent value="customer">
        <CustomerSignupForm />
      </TabsContent>
      <TabsContent value="agent">
        <AgentSignupForm />
      </TabsContent>
    </Tabs>
  )
}
