import { Skeleton } from "@/components/ui/skeleton"

export default function ItinerarySettingLoading() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-gray-50 via-white to-gray-100 p-6">
      <Skeleton className="h-32 w-full rounded-2xl mb-8" />
      <div className="max-w-2xl mx-auto space-y-6">
        <Skeleton className="h-32 w-32 rounded-xl mx-auto" />
        {[...Array(4)].map((_, i) => (
          <Skeleton key={i} className="h-16 rounded-xl" />
        ))}
        <Skeleton className="h-12 w-full rounded-xl" />
      </div>
    </div>
  )
}
