import type React from "react"
import type { Metadata } from "next"
import { FrontendHeader } from "@/components/frontend/header"
import { FrontendFooter } from "@/components/frontend/footer"

export const metadata: Metadata = {
  title: "Home | Teertham",
  description: "Welcome to Teertham - Your trusted partner for comprehensive solutions",
}

export default function FrontendLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return (
    <>
      <FrontendHeader />
      {children}
      <FrontendFooter />
    </>
  )
}
